<xsl:transform version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"		
		xmlns:mx="http://www.mobotix.com/xslfuncs">
		
<xsl:output method="html" encoding="UTF-8"/>
<xsl:strip-space elements="tr td img"/>

<xsl:variable name="translation-context">Album</xsl:variable> 
<xsl:include href="include.xsl"/>

<!--	
		Image Album Template

		prints a number of images in a tabular layout; no text decorations and other stuff.
		used by mx::SimplePrintContext.

		We support  two layout modes:

			(1)	Fixed Image Size
					image size is given; print as many images as fit on the page

			(2)	N Images per Page
					number of images per page is given; print images as large as they fit
-->

<xsl:template match="/print">

<html>
<head>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
  <style>
	BODY, TD, TH {
	  	font-family: "VAGRounded LT Thin";
  		font-size: 11pt;
  		color: #002080;
	}
  	TD,TH {
  		text-align:center;
  	}
  </style>
</head>

<body>
<center>

<!-- $mm-per-inch := millimeters per inch -->
<xsl:variable name="mm-per-inch" select="25.3"/>
<!-- $all-images := all visible images (i.e. non-empty) -->
<xsl:variable name="all-images" select="image[@width &gt; 0 and @height &gt; 0]"/>
<!-- $count-images := total number of images -->
<xsl:variable name="count-images" select="count($all-images)"/>

<xsl:choose>
	<xsl:when test="param/fixed-width">
		<!-- 
				(1) Fixed Image Size Layout 
				calculate number of rows and columns from given image size
		-->
		<!-- $cwidth := image width in pixels	-->
		<!-- $cheight := image height in pixels -->
		<xsl:variable name="cwidth" select="(param/fixed-width div $mm-per-inch) * paper/logical-dpi/@x"/>
		<xsl:variable name="cheight" select="(param/fixed-height div $mm-per-inch) * paper/logical-dpi/@y"/>
		
		<!-- $cols0 := number of columns per page -->
		<!-- $rows0 := number of rows per page -->
		<xsl:variable name="cols0" select="floor(paper/content/@width div $cwidth)"/>
		<xsl:variable name="rows0" select="floor(paper/content/@height div $cheight)"/>
		
		<!-- assert  1 <= $cols1 <= count(images) -->
		<xsl:variable name="cols1">
			<xsl:choose>
				<xsl:when test="$cols0 &lt; 1">1</xsl:when>
				<xsl:when test="$cols0 &gt; $count-images"><xsl:value-of select="$count-images"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$cols0"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- $rowsm := max. number of rows -->
		<xsl:variable name="rowsm" select="floor(($count-images + $cols1 - 1) div $cols1)"/>
		<!-- assert  1 <= $rows1 <= max. rows -->
		<xsl:variable name="rows1">
			<xsl:choose>
				<xsl:when test="$rows0 &lt; 1">1</xsl:when>
				<xsl:when test="$rows0 &gt; $rowsm"><xsl:value-of select="$rowsm"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$rows0"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- now we have calculated all parameters to lay out the table: -->
		<xsl:call-template name="album-table">
			<xsl:with-param name="images" select="$all-images"/>
			<xsl:with-param name="cell-width" select="$cwidth"/>
			<xsl:with-param name="cell-height" select="$cheight"/>

			<xsl:with-param name="columns" select="$cols1"/>
			<xsl:with-param name="rows" select="$rows1"/> 
		</xsl:call-template>
	</xsl:when>
	
	<xsl:when test="param/images-per-page">
		<!-- 
				(2) Layout N Images on a Page
				calculate image size 

				we use a simple heuristic for laying out the table:
					1x2
					2x2
					2x3
					2x4
					3x3
					3x4
					3x5
					4x4
					4x5
				or vice versa in landscape mode
		-->
		<!-- $n := number of images per page
				assert $n <= count(images) -->
		<xsl:variable name="n">
			<xsl:choose>
				<xsl:when test="param/images-per-page &gt; $count-images"><xsl:value-of select="$count-images"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="param/images-per-page"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- $cols0 := number of columns -->
		<xsl:variable name="cols0">
			<xsl:choose>
				<xsl:when test="$n &lt;= 2">1</xsl:when>
				<xsl:when test="$n &lt;= 8">2</xsl:when>
				<xsl:when test="$n &lt;= 15">3</xsl:when>
				<xsl:otherwise>4</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- $rows0 := number of rows -->
		<xsl:variable name="rows0">
			<xsl:choose>
				<xsl:when test="$n &lt;= 1">1</xsl:when>
				<xsl:when test="$n &lt;= 4">2</xsl:when>
				<xsl:when test="$n &lt;= 6">3</xsl:when>
				<xsl:when test="$n &lt;= 8">4</xsl:when>
				<xsl:when test="$n &lt;= 9">3</xsl:when>
				<xsl:when test="$n &lt;= 12">4</xsl:when>
				<xsl:when test="$n &lt;= 15">5</xsl:when>
				<xsl:when test="$n &lt;= 16">4</xsl:when>
				<xsl:otherwise>5</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<!-- swap columns and rows for landscape mode -->
		<xsl:variable name="cols1">
			<xsl:choose>
				<xsl:when test="paper/@width &lt; paper/@height"><xsl:value-of select="$cols0"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$rows0"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="rows1">
			<xsl:choose>
				<xsl:when test="paper/@width &lt; paper/@height"><xsl:value-of select="$rows0"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="$cols0"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>	

		<!-- now we have calculated all parameters to lay out the table: -->
		<xsl:call-template name="album-table">
			<xsl:with-param name="images" select="$all-images"/>
			<xsl:with-param name="columns" select="$cols1"/>
			<xsl:with-param name="rows" select="$rows1"/>
			<xsl:with-param name="cell-width" select="paper/content/@width div $cols1"/>
			<xsl:with-param name="cell-height" select="(paper/content/@height - $rows1*25) div $rows1"/>
		</xsl:call-template>
	</xsl:when>
</xsl:choose>

</center>

</body>
</html>

</xsl:template>



<!--
	Album Table Template
-->	
<xsl:template name="album-table">
	<!-- node-set of images -->
	<xsl:param name="images"/>
	<!-- number of columns -->
	<xsl:param name="columns"/>
	<!-- number of rows per page -->
	<xsl:param name="rows"/>
	<!-- actual column width (in screen pixels) -->
	<xsl:param name="cell-width"/>
	<!-- actual row height (in screen pixels) -->
	<xsl:param name="cell-height"/>

	<!-- iterate over the images, create a <TD> for each image
		insert <TR> and page breaks as necessary
	-->
	<xsl:for-each select="$images">
		<!-- $col := current column -->
		<xsl:variable name="col" select="(position()-1) mod $columns"/>
		<!-- $r0 := current row (regardless of page) -->
		<xsl:variable name="r0" select="floor((position()-1) div $columns)"/>
		<!-- $page := current page -->
		<xsl:variable name="page" select="floor($r0 div $rows)"/>
		<!-- $row := current row on page -->
		<xsl:variable name="row" select="$r0 mod $rows"/>
		
		<xsl:if test="$col=0">
			<!-- $col=0 : start of a new row -->
			<!-- close previous row -->
			<xsl:if test="$row &gt; 0"><xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text></xsl:if>
	
			<!-- $col=0 and $row=0 : start of a new page -->
			<xsl:if test="$row=0">
				<!-- close previous page -->
				<xsl:if test="$page &gt; 0">
					<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
					<p style="page-break-before:always;"/>
				</xsl:if>
				<!-- open new page -->
				<xsl:text disable-output-escaping="yes">&lt;table&gt;</xsl:text>
			</xsl:if>
			<!-- open new row -->
			<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
		</xsl:if>
		
		<!-- now comes the <TD> and <IMG> -->
		<td>
		<!--
			<xsl:value-of select="$page"/>,<xsl:value-of select="$row"/>,<xsl:value-of select="$col"/>
		-->	
			<xsl:call-template name="img-scale">
					<xsl:with-param name="img" select="current()"/>
					<xsl:with-param name="max-width" select="$cell-width"/>
					<xsl:with-param name="max-height" select="$cell-height"/> 
			</xsl:call-template>
		</td>
	</xsl:for-each>
	
	<!-- close row and table -->
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
	<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
</xsl:template>


</xsl:transform>
